# The contributions of qualitative comparative analysis (QCA) to international business research

Stav Fainshmidt1 , Michael A Witt2 , Ruth V Aguilera3,4 and Alain Verbeke5,6,7

1 Florida International University, Miami, USA; 2 INSEAD, Singapore, Singapore; 3 Northeastern University, Boston, USA; 4 Esade Business School, Universitat Ramon Llull, Barcelona, Spain; 5 University of Calgary, Calgary, Canada; 6 Henley Business School, University of Reading, Reading, UK; 7 Solvay Business School, Vrije Universiteit Brussel, Brussels, Belgium

Correspondence:   
A Verbeke, University of Calgary, Calgary, Canada   
e-mail: alain.verbeke@haskayne.ucalgary.ca

# Abstract

International business (IB) researchers have been slow to embrace a configurational approach in hypothesis formulation and empirical analysis. Yet, much of what IB scholars study is inherently configurational: various explanatory factors and their interplay simultaneously determine the outcome(s) studied, such as governance choice or firm-level performance. The mismatch between the nature of the empirical phenomena studied on the one hand, and hypothesis formulation and empirical methods deployed on the other, explains why many quantitative empirical studies in IB are overly reductionist, relying on hypotheses that assume linear (or simple, curvilinear), unifinal, and symmetrical effects. In this Editorial, we introduce IB scholars to contemporary configurational thinking and its analytical tool, fuzzy-set qualitative comparative analysis (fsQCA). We discuss this tool’s main tenets, advantages, and disadvantages. We review the limited prior IB research using this approach and present a wide range of IB phenomena where it could be usefully applied. We propose that contemporary configurational thinking and fsQCA can help scholars produce insights more closely aligned with the complex realities of international business than conventional research approaches.

Journal of International Business Studies (2020) 51, 455–466. https://doi.org/10.1057/s41267-020-00313-1

Keywords: fsQCA; fuzzy sets; qualitative comparative analysis; configurational analysis

# INTRODUCTION

Much of what international business (IB) researchers study is inherently configurational or gestalt-like. Several decades ago, Dunning (1988, p. 2) observed that the extent, form, and pattern of international production are determined by the combination – or what we will refer to in this paper as configuration – of three sets of advantages: ownership, location, and internalization. Strategy scholars have long recognized that organizations are open systems, and that superior performance or competitive advantage are achieved by aligning strategies, structures, and environmental conditions (Miller, 1987). Yet, IB research has been slow to embrace a configurational approach to empirical analysis, even though some influential IB theories are inherently configurational (Nielsen, Eden, & Verbeke, 2020). For example, the transaction cost economics approach to multinational enterprise (MNE) governance choices argues that behavioral elements (bounded rationality and bounded reliability) work in concert with asset specificity levels, or more broadly the levels of complex resource combinations at hand, and macro-institutional features, to jointly determine what constitutes the best governance approach. Much empirical work, however, shows a mismatch between inherently configuration-based theory and actual hypotheses, whereby the latter often assume linear (or simple, curvilinear), unifinal, and symmetrical effect, and are then paired with reductionist modes of inquiry (Meyer, Tsui, & Hinings, 1993). As many IB phenomena are inherently configurational, both hypothesis formulation and empirical design should be aligned with this reality.

In recent years, modern configurational thinking has emerged in business research (Misangyi, Greckhamer, Furnari, Fiss, Crilly, & Aguilera, 2017). Rooted in set theory and in Ragin’s (2000) work on fuzzy-set qualitative comparative analysis (fsQCA), the approach provides researchers with tools for conceptualizing research questions and analyzing data in configurational terms. There are now some creative studies employing it; these studies allow rethinking extant theory, or making it more actionable by deploying the appropriate analytical tools (e.g., Bell, Filatotchev, & Aguilera, 2014; Crilly, 2011; Witt & Jackson, 2016). In this Editorial, we outline the basic features of fsQCA, briefly review relevant work, and most importantly, call for IB studies using this approach.

# QUALITATIVE COMPARATIVE ANALYSIS

Configurational thinking is not new to IB scholars, but earlier work in IB and related fields (e.g., Dunning, 1988) lacked the methodological tools needed for making this thinking actionable in empirical terms. With a configurational approach, selected outcome variables such as organizational choices, practices, and performance indicators (whether at the firm level or macro level), derive from complex interactions among interrelated parameters. The challenge is to determine how configurations of variables taking on particular values are associated with a particular outcome. Underpinning the approach is the explicit modeling of elements such as conjunctural causation (when an effect depends on a combination of causes),1 equifinality, causal asymmetry, and sufficiency, all discussed below. According to Misangyi et al. (2017: 257), this approach ‘‘enables researchers to more adequately theorize and empirically examine causal complexity.’’

The present interest in configurational thinking owes much to the development of fsQCA, a settheoretic method for establishing which conditions are sufficient (and in some instances also necessary) to produce a given outcome. It offers an alternative for – or complement to – linear regression analysis that is particularly suitable for the kinds of complex phenomena and causal relationships we commonly see in IB. Below, we briefly explain the foundations of fsQCA and then explore its advantages over conventional regression analysis, as well as its limitations.

# Foundations

We will keep our introduction to fsQCA brief. Further conceptual details and empirical guidance is available in standard works on the method, especially the seminal contributions of Ragin (1987, 2000, 2008) and Fiss (2007, 2011), as well as Schneider & Wagemann (2012). Greckhamer, Furnari, Fiss, & Aguilera (2018) have summarized current best practice in the strategy field.

QCA can have two basic forms: crisp-set and fuzzy-set. In crisp-set QCA, causal conditions and outcomes are coded either as absent $( ^ { \prime } 0 ^ { \prime } )$ or present (‘1’), with nothing in between, and without any ambiguity in play. For example, when conducting a study on how an institution such as the OECD could affect corporate governance in individual countries, there is no ambiguity on the status of these individual countries: Bolivia is not a member of the OECD $( ' 0 ^ { \prime } )$ , whereas Spain is (‘1’). Fuzzy-set QCA follows the same fundamental logic as crispset QCA but typically assumes a spectrum of possible values. A general heuristic is that $' 0 ^ { \prime }$ means a condition is fully absent; $^ { \prime } 0 . 5 ^ { \prime }$ neither absent nor present;2 and $^ { \prime } { 1 ^ { \prime } }$ fully present. For example, the United States are not subject to European Union rules $( ' 0 ^ { \prime } )$ , whereas France (‘1’) is. Norway, though not a formal EU member, is still strongly affected by the EU regulatory framework (earning a score that could, e.g., be ${ } ^ { \prime } 0 . 6 { } ^ { \prime } )$ ).

Data that do not naturally take the value of $\mathrm { \prime 0 \mathrm { \prime } }$ or $\mathbf { \prime } _ { 1 } \mathbf { \prime }$ need ‘calibration’. There are two distinct methods of calibration: manual calibration, by which researchers use their expert judgment to assign a value between $' 0 ^ { \prime }$ and $\mathbf { \prime } _ { 1 } \mathbf { \prime }$ to each observation, and approaches in which an algorithm is used to select the values (Ragin, 2008). While the latter approach might seem more objective, Ragin (2008) finds some merit in researchers using their expertise to derive a meaningful calibration.

Consider the Corruption Perception Index (Transparency International, 2018), which rates countries on a scale from $\mathrm { \Omega ^ { \prime } } _ { 0 } \mathrm { \Omega }$ (fully corrupt) to $\mathbf { \omega } ^ { \prime } _ { 1 0 0 ^ { \prime } }$ (fully clean). In manual calibration, a researcher might decide that all countries having a rating below $\prime _ { 2 0 ^ { \prime } }$ are fully corrupt $( ' 0 ^ { \prime } )$ while those higher than $' 8 0 '$ are fully clean (‘1’). Countries having a rating from $^ { \prime } 2 1 ^ { \prime }$ to $^ { \prime } 5 0 ^ { \prime }$ might then be calibrated as ‘‘more corrupt than clean’’ (receiving a score of $\mathit { \Omega } ^ { \prime } 0 . 3 3 \mathit { \check { \Omega } } ,$ ), while having a rating between $^ { \prime } 5 1 ^ { \prime }$ and $\mathbf { \prime } _ { 7 9 ^ { \prime } }$ might be calibrated as ‘‘more clean than corrupt’’ (receiving a score of $ { { } ^ { \prime } } 0 . 6 7  { { } ^ { \prime } } )$ ). In algorithmbased approaches, the researcher would determine anchor points or a rough grouping into set-membership scores and then use statistical software to produce the final calibration scores. The COMPASSS website (http://www.compasss.org/index. htm) provides an overview of available software packages and other resources.

The notion of calibration highlights a core difference between fsQCA and other statistical techniques. Other statistical techniques typically operate on the basis of parameters that vary in value (or in kind, for categorical variables). In contrast, fsQCA operates on causal conditions or sets, which differ both in ‘kind’ (present or absent) and in ‘degree’ (of presence or absence). With regression analysis, researchers estimate a change in a dependent variable, on average, given a oneunit change in the independent variable. With fsQCA, researchers identify whether the presence or absence of causal conditions (and their combinations) are consistent with the presence or absence of a particular outcome. This type of set-theoretic relationships among conditions is at the heart of the modern configurational approach and fsQCA.

The output or ‘solution’ provided by fsQCA is usually that one or several configurations of causal conditions are sufficient to produce the given outcome. Output quality is judged against two key statistics that vary between $\mathrm { \prime 0 \mathrm { \prime } }$ and $\cdot _ { 1 } \cdot _ { }$ : coverage and consistency. Coverage measures the proportion of membership in the outcome explained by the configurations identified through the analysis. Consistency reflects the extent to which the presence of the supposedly sufficient configurations actually produces (i.e., is consistent with) the outcome. While higher coverage is generally better, there is no commonly agreed minimum coverage a QCA analysis must reach for the results to be considered valid. On the other hand, the consensus seems to be that consistency levels should at least be $\cdot 0 . 7 5 '$ or higher (Ragin, 2008). Current best practice further recommends that each solution meet a threshold of $\mathrm { ^ { \prime } 0 . 7 0 ^ { \prime } }$ for proportional reduction in inconsistency (PRI) (Greckhamer et al., 2018).

# Advantages

QCA has six main advantages. First, while it can work with very large sample sizes (e.g., Witt & Jackson, 2016), it was originally designed to work with small sample sizes, far below those required for standard regression analysis. Charles Ragin, who originally developed QCA, explicitly designed it for analysis of medium-sized samples – those too large for in-depth case studies but too small for regression analysis (Ragin, 2000). QCA is typically a reasonable choice of method for sample sizes of 12 or more, with the minimum sample size depending on the number of causal conditions included in the model (Marx, 2006). For example, QCA with four causal conditions requires a minimum sample size of 12, while seven causal conditions require a sample of about 30 (Marx, 2006). Models with more than seven causal conditions can be constructed in principle, but given the large number of parameters involved, the results can become difficult to interpret, and such models should therefore be avoided, as discussed below.

Second, QCA is particularly suitable for identifying multiple configurations of causal conditions that are sufficient for a given outcome. A single causal condition is rarely sufficient to explain the presence of a particular outcome. For instance, the sole fact that China is a large potential market may be insufficient to persuade firms from an advanced industrialized country that have no prior international business dealings to build a production site there. However, if these companies were at the same time experiencing shrinking revenues at home and facing trade barriers to potential exports to China, these three factors combined may be sufficient to drive production in China.

Outcomes are thus often produced by the conjunctural causation of multiple causal conditions. In regression analysis, these interdependencies are usually modeled as interaction terms. However, these become increasingly difficult to interpret once the number of interacting variables exceeds two. In contrast, QCA was explicitly designed to identify the configurations of causal conditions that are sufficient to produce a given outcome. This emphasis on configurations also explains why QCA usually refers to causal conditions rather than independent variables. Implicit in the notion of an independent variable is that it is possible to isolate the effect of such a variable on the dependent variable by changing its values while holding all other independent variables constant. By contrast, in configurational analysis, it is the joint presence or absence of a set of given causal conditions that produces a given outcome.

Third, QCA explicitly allows for equifinality of different combinations of causal conditions. Equifinality means that different configurations of causal conditions (paths) can lead to the same outcome. Let us again consider the example of firms investing in China. An alternative sufficient configuration of causal conditions, valid for other firms than those considered above, may involve low labor costs, rising revenues at home and the presence of competent component suppliers. There can thus be multiple pathways to the same outcome, i.e., to invest in China. Standard regression analysis would not be able to identify these different pathways. Indeed, since the signs of different conditions may change across configurations (in the example above, this was the case with the trend of revenues), regression analysis may well fail to identify the precise role of a given causal condition when explaining the absence or presence of the outcome of interest.

Fourth and relatedly, QCA allows for asymmetric solutions for the absence and presence of a given outcome. In simplified terms, the causal conditions leading to the absence of a particular outcome do not need to be the inverse of the conditions that lead to the presence of this same outcome. In the above example, the simultaneous presence of three conditions – large potential target market, shrinking revenues and high trade barriers – were sufficient for firms to invest in China. However, a decision to stay out of China does not therefore require the absence of all three causal conditions. The combination of viewing China as a small target market, having rising revenues at home, and facing low import barriers does not mean that firms will necessarily reject investments in this country. In this example, the asymmetry is easy to understand: the presence of the causal conditions triggers market-seeking investment in China. But in the absence of this configuration of causal conditions, some firms may still invest in China, inter alia to pursue resource seeking projects that build on low labor costs and other conditions in the supply chain sphere. This type of asymmetry is difficult to capture by standard regression analysis.

Fifth, keeping the number of causal conditions small is possible because QCA has no omitted variable bias in the same way regression analysis does. In regression analysis, leaving out relevant independent variables not only decreases explanatory power, but if the missing variable is correlated with included variables, the coefficient estimates of the included variables will be biased. These estimates will pick up part of the effect of the missing variable. In QCA, leaving out a relevant condition will decrease the explanatory power of the model. However, since the method draws on Boolean algebra rather than on correlations, it will not result in an omitted variable bias. One implication is the absence of a methodological requirement for control variables, which is important for readers (including reviewers) to understand when scrutinizing QCA-based research.

Sixth, it is common for scholars deploying fsQCA to pull out from the raw data specific examples of each of the configurations. This makes it possible to engage in additional qualitative exploration, and even to expand the analysis via case studies. It also demonstrates, again with the above example in mind, that different companies might decide not to enter, or conversely to enter, a given foreign market as a function of different sets of explanatory factors. In general, fsQCA allows configurations of causal conditions to emerge from the data, which can serve to stimulate theory development in addition to theory testing of expected, a priori configurations (e.g., Fainshmidt, Wenger, Pezeshkan, & Mallon, 2019).

# Limitations

Although QCA has distinct advantages over regression analysis, it also has five important limitations. First, data calibration can both support and detract from the validity of the results. While Ragin (2008) emphasized the potential value of letting researchers use their own expertise to do the calibration, a flawed calibration process will lead to distorted findings. Research studies relying on manual calibration should therefore provide a detailed explanation of the calibration process adopted and its underlying rationale.

Second, QCA typically tests for sufficiency, not for necessity. This is clear from our earlier example where the combination of a large host market, shrinking revenues, and high export barriers was sufficient to motivate a company to enter China. This combination is clearly not necessary for all investments in China, as we suggested with a second possible configuration of conditions leading to such investments. Only under very specific circumstances can one infer that a given causal condition is necessary. This usually occurs when the analysis conducted explains all, or almost all, of the observed outcomes and one specific causal condition is consistently present or absent across all configurations leading to the observed outcomes. Fuzzy-set QCA has the capacity to examine necessity, but this is done separately from (and is often recommended prior to) the sufficiency analysis (Schneider & Wagemann, 2012). As a general recommendation, research seeking to identify necessity should also rely on alternative methods, such as Necessary Condition Analysis (Dul, 2016).

Third, the results produced by QCA become increasingly complex as the number of causal conditions increases. Assuming that each causal condition is a binary variable ( $' 0 ^ { \prime }$ meaning absent; $\mathbf { \prime } _ { 1 } \mathbf { \prime }$ meaning present), as in crisp-set QCA, the number of possible configurations is $2 ^ { k }$ , where $k$ is the number of causal conditions. Every additional condition thus doubles the possible number of configurations. For instance, seven causal conditions in a model result in up to 128 possible configurations of the presence or absence of each of these conditions. While many of these configurations may not be relevant as influencing the outcome, this makes QCA results more difficult to interpret.

Fourth, QCA is not a statistical technique for hypothesis testing in the sense of sample-to-population inference. There are indicators of the quality of a QCA model, as discussed earlier, but the scholars who originally developed QCA did not have in mind the concept of ‘giving a probability that a particular relationship does not arise by chance’ (see Braumoeller, 2015 for further analysis).

Fifth, formulating hypotheses about configurations of causal conditions is challenging. As mentioned above, the number of possible configurations doubles with each additional causal condition. Ideally, theory should allow us to hypothesize ex ante which of these configurations are likely to lead to a particular outcome. In practice, we could not identify many IB-related papers that succeeded in doing so. Witt and Jackson (2016), one exception, hypothesized which two configurations out of a possible 32 would lead to institutional comparative advantage. This shortcoming is not related to the QCA methodology per se. The main problem is many researchers’ lack of experience in formulating relatively complex scenarios that describe how configurations of variables could reasonably lead to specific outcomes. Conventional regression analysis has conditioned many researchers to hypothesize isolated, supposedly plausible main effects of individual parameters on an outcome variable, possibly to be supplemented with moderators, thereby often refraining from carefully thinking through complex scenarios.

# FUZZY-SET QCA IN INTERNATIONAL BUSINESS RESEARCH

IB researchers have only recently started applying fsQCA. While a full review of fsQCA papers relevant to IB is beyond the scope of this Editorial, we do highlight in Table 1 a number of studies that, in our view, have made significant theoretical and empirical contributions, and can be used as a platform for future IB studies. Below, we also briefly describe a few of these studies.

Pajunen (2008) conducted one of the first IB studies using fsQCA as a formal configurational approach. Using archival data on the institutional features of 47 developed and developing countries, he set out to determine the combinations of conditions (out of a set of seven causal conditions) that make countries attractive or unattractive to MNE foreign direct investment (FDI). He found, consistent with the equifinality and conjunctural causation principles, that multiple combinations of institutional features are associated with FDI or the absence thereof. For instance, he argued (p. 660): ‘‘…the findings imply that, among the developed countries that all have political rights and civil liberties, flexible labor regulation may be the only institutional factor that actually increases the attractiveness for FDI.’’ In the realm of less developed countries, however, he also found two scenarios (among many) where a single factor appeared sufficient to make a country attractive to FDI (p. 662): ‘‘…non-corruptness and property rights alone are seen as sufficient conditions for membership in the set of an FDI-attractive country.’’

Crilly (2011) argued that foreign subsidiaries pursue strategies that are either narrowly focused on shareholders or more broadly on various stakeholders. A stakeholder orientation is a key feature of subsidiary strategy that can significantly affect its performance. Crilly built theory using qualitative data collected from 52 subsidiaries of $1 3 \mathrm { M N E s }$ , and he brought rigor to his qualitative analysis by subjecting the data to fsQCA. The exercise proved fruitful, as he was able to identify configurations of external and internal conditions associated with the presence of a narrow versus broad stakeholder orientation. For instance, subsidiaries requiring specialized human capital appear likely to have a broad stakeholder orientation when they are also subject to local government influence, or when their parents command substantial slack resources. One of the advantages of combining fsQCA with traditional qualitative analysis is that it is possible to use both as complementary lenses to understand better causal patterns and their underlying mechanisms. In this instance, Crilly’s (2011) study usefully demonstrated the capacity of fsQCA to analyze data and phenomena that are inherently multi-level: understanding subsidiary stakeholder orientation requires combining conventional explanations focused on environmental factors, with a perspective based on the role of the MNE parent as resource provider.

Table 1 Selected international business studies applying fsQCA   

<html><body><table><tr><td colspan="6">lesappiyingTsQCA</td></tr><tr><td>Study Pajunen</td><td>Research topic Country</td><td>Sample and data Archival data on inward</td><td>QCA findings The combinations of institutions that atract foreign</td><td>Implications for IB No single factor makes a country attractive or</td></tr><tr><td>(2008, JIBS)</td><td>attractiveness to foreign direct investors</td><td>foreign direct investment flows to 47 host countries</td><td>direct investors differ between developed and developing countries. For instance, flexible labor regulation and favorable taxation are jointly important in developed countries. In less-developed countries,corruption and lack of property rights appear important, but are not</td><td>unattractive to foreign investors.Different configurations of causal conditions, i.e. paths, might lead to a different or the same outcome,even within a relatively homogeneous group of countries.This explains why earlier research has produced mixed results</td></tr><tr><td>Schneider, Schulze- Bentrop,&amp; Paunescu (2010, JIBS)</td><td>Country export performance in high tech industries2003</td><td>Archival data on 19 OECD countries between 1990 and</td><td>sufficient institutional conditions to deter FDl inflows The findings show that the combination of having many university graduates and a large stock market leads a country to have large high- tech exports. However, it can &quot;borrow&quot; these institutions by accessing the talent pool of other countries through</td><td>Consistent with the idea of institutional complementarities,whereby no single institutional characteristic is sufficient for explaining high tech export performance, some high- performing countries have hybrid models that combine</td></tr><tr><td>Crilly (2011, JIBS)</td><td>Subsidiary stakeholder orientation</td><td>Interview data on 52 subsidiaries of 13 MNEs</td><td>international mergers and acquisitions Three configurations of external and internal conditions are associated with a foreign subsidiary having broad stakeholder orientation, and three with a narrow on. For example,subsidiaries requiring specialized human capital are likely to have a broad stakeholder orientation when they are subject to local</td><td>features of liberal market and coordinated market economies A mid-range theory of a foreign subsidiary&#x27;s stakeholder orientation based on environmental factors and on the strategies of its parent</td></tr><tr><td>Kim (2013, JIBS)</td><td>Geographic scope as an isolating mechanism and sustainable competitive advantage</td><td>Archival data on 802 semiconductor patent applications to the United States Patent and Trademark Office (USPTO) in 1990</td><td>government influence,or when their parents have substantial slack Nine configurations of causal factors result in barriers to imitation. Different configurations or combinations of causal factorsimitation can create these barriers and are functionally equivalent and mutually substitutable</td><td>Along with the inherent characteristics of the knowledge, global technology sourcing can create barriers to</td></tr></table></body></html>

<html><body><table><tr><td colspan="5">Table 1 (Continued)</td></tr><tr><td>Study Bell et al.</td><td>Research topic Valuation of IPOs ofArchival data on 198 firms</td><td>Sample and data</td><td>QCA findings A high perceived IPO value is</td><td>Implications for IB Advances the concept of nested legitimacy: how</td></tr><tr><td>(2014,AMJ)</td><td>foreign firms in thefrom 36 countries listing United States</td><td>shares in the United States</td><td>associated with six configurations of contextual conditions,investor country of origin,and firm governance. For example, the presence of CEO stock options and the absence of an independent board lead to high perceived IPO value for older firms competing in high-tech industries</td><td>foreign firms based in countries with strong investor protection can obtain high investor valuation for their IPOs even without some strong corporate governance rules such as CEO stock options or venture capital backing. This option is not available to firms based in countries with weak investor</td></tr><tr><td>Judge et al. (2014, JIBS)</td><td>National wealth creation and inequality</td><td>Archival data on 48 developed and developing economies</td><td>Three configurations of institutions are possible for countries that generate wealth efficiently and share it equitably.Three other configurations characterize</td><td>protection There is no single optimal model of capitalism, consistent with the equifinality tenet of fuzzy-set theory</td></tr><tr><td>Fainshmidt, Smith,&amp; Judge (2016， competitiveness GSJ)</td><td>Porter&#x27;s diamond model and national</td><td>Archival data on 90 countries</td><td>countries that do not Four configurations are sufficient for high national competitiveness.All of these include high governance quality,but not the extent of foreign direct investment penetration.The presence of all the elements in Porter&#x27;s diamond theory of national</td><td>A comprehensive theoretical framework of the antecedents of competitiveness that,in addition to the variables in Porter&#x27;s diamond,include a country&#x27;s quality of public governance and its openness to foreign investment.The model shows how these</td></tr><tr><td>Greckhamer (2016, SMJ)</td><td>to-worker compensation ratio across countries</td><td>CEO pay and CEO-Archival data on 54 countries in 2001,2005,and 2009</td><td>advantage is neither necessary nor sufficient for high national competitiveness Some institutional configurations are linked to the level of the pay gap between executives and other employees. For example, there is a low pay gap in countries with strong labor institutions and low power</td><td>antecedents are either complements or substitutes While the presence of some institutions leads to a high pay gap, their absence does not necessarily lead to a low one</td></tr><tr><td>Witt &amp; Jackson (2016, JIBS)</td><td>and comparative advantages</td><td>National institutionsArchival data on 14 industries in 22 countries over 9 years</td><td>foreign capital penetration depends on the institutional context Countries that combine coordinated and liberal market economy features have a comparative advantage in high-tech industries</td><td>In contrast to the predictions of the ‘varieties of capitalism&#x27; literature,hybrid institutions give a country a comparative advantage in innovative industries</td></tr></table></body></html>

Table 1 (Continued)   

<html><body><table><tr><td>Study</td><td>bieT（Contimueu) Research topic EMNE political</td><td>Sample and data</td><td>QCA findings</td><td>Implications for IB</td></tr><tr><td>Chen, Li,&amp; Fan (2018, GSJ)</td><td>connections and investment location choice</td><td>Archival and survey data on 75 Chinese high-tech firms venturing in 28 host countries</td><td>Six configurations of political connections,MNE resources, and industry context associated with foreign direct investment into high or low institutional distance host countries.For instance, home political connections are most useful in helping EMNEs overcome high institutional distance with FDl when the firms operate in a munificent</td><td>Provides a comprehensive framework to understand the choice between high and low institutional distance locations, whereby conditions derived from the institution- based,resource-based,and industry-based views interact to shape FDI location decisions</td></tr><tr><td>Ciravegna, Kuivalainen, Kundu,&amp; Lopez (2018, IBR)</td><td></td><td>Antecedents of early Interview data on 29 Costa internationalizationRican B2B software exporters</td><td>industry and lack commitment to R&amp;D Three distinct combinations ofA combination of causal antecedents are equifinally linked to the early internationalization of Costa Rican small and medium-sized enterprises</td><td>factors explains early internationalization</td></tr><tr><td>Verbeke et al. (2018, JMS)</td><td>Opportunism by import partners in entry</td><td>Interview and survey data on 133 entries into new markets international market by 38 Chinese exporters</td><td>Five configurations resulting in exporters being taken advantage of by importers. For instance, young firms that lack both an experienced manager and personal contacts in the foreign market entered are likely to be subject to opportunism by importers. In one configuration,older firms with experienced managers and many personal contacts in the target country experienced opportunism by importers, when entering a</td><td>No single variable on its own is associated with importer opportunism.Rather,a set of conditions determines its occurrence. This goes beyond the assumption of opportunism in transaction theory and shows how managers can anticipate and mitigate the effects of opportunism in international markets</td></tr></table></body></html>

In addition, fsQCA can also be used for theory testing. Bell et al. (2014) studied the valuation of foreign IPOs in the US market. They extended institutional theory by developing the concept of nested legitimacy, whereby: ‘‘the process of legitimation through governance may be nested in a broader context of investors’ perceptions of the legitimacy of institutions associated with a foreign $\mathrm { I P O } ^ { \prime } s$ home country’’ (p. 304). Foreign IPO firms from jurisdictions with strong governance appeared to earn legitimacy from simple corporate governance rules (e.g., the presence of external monitoring by venture capital in case a younger technology-based firm was involved). In contrast, firms from countries with weak institutional governance had to adopt additional micro-level governance rules to gain the same level of legitimacy (e.g., the combination of external monitoring and incentive alignment). Investors thus first assess the corporate governance context of the home country of the firm doing the IPO, and on that basis determine the corporate governance rules needed for a high valuation. Looking at IPOs by 198 firms from 36 countries, the authors found six configurations of complementary and substitutable institutional and firm-level governance mechanisms that resulted in a high IPO price premium. These configurations provided support for the nested legitimacy concept.

Building on a rich literature on ‘varieties of capitalism’ in political science and sociology (e.g., Hall & Soskice, 2001; Whitley, 1999), Witt & Jackson (2016) investigated how national institutions affect national comparative advantage. They distinguished between liberal and coordinated economies and introduced the new concept of ‘beneficial constraints’. This concept means that opposing institutional logics can jointly contribute to comparative advantage. Based on archival data on 14 industries in 22 countries over 9 years, they showed that configurations mixing features from coordinated economies and liberal economies can generate comparative advantage in industries characterized by radical innovations. In contrast, in industries characterized by incremental innovation, it was configurations of institutional features typical for coordinated economies that yielded comparative advantage.

Finally, a recent study by Verbeke, Ciravegna, Lopez, & Kundu (2018) explored opportunism on the part of importers, which is a substantial obstacle faced by exporting firms. The authors examined 133 entries into new markets by 38 Chinese exporters and identified five configurations of opportunism by importers. For instance, young firms experienced opportunism when they lacked both an experienced manager and a large network of foreign contacts. In one configuration, even older firms with experienced managers and a large network were subject to partners behaving opportunistically, namely when entering a distant market. This study suggested that predictions on the occurrence of opportunism based on a single explanatory variable, should make way for a configurational approach, whereby it is recognized from the outset that a number of causal conditions must typically be in place for opportunism to materialize.

# FUTURE RESEARCH

Our review suggests that IB research has underutilized configurational thinking and related QCA techniques. It could benefit greatly from drawing more systematically on both. There are at least six areas with promising opportunities for future research using QCA. First, one of the most attractive attributes of thinking in terms of configurations of conditions affecting an outcome is the positioning of such approach at the intersection of qualitative and quantitative research. Combining qualitative and quantitative elements can in many instances provide a parsimonious, yet accurate, explanation of complex IB phenomena. Many classic IB research questions have in the past been addressed through simple quantitative approaches focused on one or a few independent variables, or through descriptive case studies with a very large number of elements somehow related to an outcome variable. Usage of fsQCA can test the robustness of existing theories and typologies, since this technique allows uncovering sometimes complex relationships among sets of conditional factors and outcomes.

We encourage scholars to return to research questions that have not been conclusively answered, such as the determinants of MNE performance or foreign location choice, to explore whether the mixed findings of previous studies can be resolved with modern configurational thinking and fsQCA. Similarly, we may be able to find better answers to some challenging questions that have configurational drivers, such as social and economic inequality, climate change, and food security (Buckley, Doh, & Benischke, 2017; Judge, Fainshmidt, & Brown, 2014). Exploring empirically how combining elements from different theories can explain a given phenomenon is also promising. For example, a theory focused on explaining phenomena at the national level could identify a configurational path that leads to an outcome of interest (e.g., a country’s international leadership in environmental innovation in various industries), whereas a theory anchored at the firm level might uncover a second configuration, leading to this same outcome. In this case, a macro-level theory and a micro-level one may both provide a credible explanation for this outcome. Each theory and its related, proposed configuration of causal conditions may have particular relevance to a number of cases in the sample being considered, in the above case involving country-level variables and firmlevel variables respectively. In this instance, followup, fine-grained qualitative studies can then use these QCA results as a starting point to assess when macro-level elements matter most, versus when firm-level parameters dominate, and when it is a mix of both that drive the outcome.

Second, QCA has important methodological advantages. For instance, it lends itself to multilevel analyses that are essential in IB: after all, managers can be grouped into teams, teams into firms, firms into industries, industries often into countries, and countries into regions. IB scholars could thus benefit greatly from using fsQCA, because the main relevant variables in the phenomena of interest are typically found at different levels. In addition, equifinality, as opposed to linear best-fit solutions, allows us to test the boundary conditions within which particular theories with supposed predictive capacity may be valid. Whereas conventional statistical testing is fairly limited in its ability to accommodate higher order interactions, fsQCA can address causal complexity and support developing typologies, as well as more holistic, nuanced, and comprehensive explanations of outcomes.

Third, the calibration of explanatory factors and outcomes to determine their degree of inclusion in a set allows for more refinement than continuous or categorical variables in linear regression-like approaches. For instance, variations in ownership share between 51 and $5 3 \%$ are substantively different from those between 49 and $5 1 \%$ . The former variation reflects a change in a firm’s degree of control, but the latter represents a change in the degree and in the kind of control, namely from minority to majority ownership. This distinction between the two situations can be formalized in fsQCA through the calibration process. If the causal condition considered were firm-level control (with $\mathrm { \prime 0 \mathrm { \prime } }$ reflecting no control, and $\cdot _ { 1 } \cdot _ { }$ meaning full control), then an ownership level of $5 1 \%$ could already be given a score of, e.g., $\cdot 0 . 6 7 ^ { \prime }$ to indicate its degree of membership in the set of full control cases. Because conditions embody differences in both kind and degree, fsQCA permits IB researchers to develop and test theories that accommodate conceptual nuances often not permitted when applying traditional linear thinking and methodologies.

Fourth, IB researchers may find fsQCA useful because of its capacity to analyze medium-sized samples. Some research designs cannot be implemented with traditional approaches because scholars do not have access to a sample large enough to apply standard linear regression models, nor one small enough to be amenable to qualitative methods such as comparative case studies. For instance, all but four of the empirical papers published in JIBS in 2018 had large samples, with hundreds or thousands of observations. Of the four not having large samples – all of these being qualitative – three had eight observations and only one, that of Clark, Li, and Shepherd (2018), had a mid-sized sample of 17.

The problem of small sample sizes is neither new nor unique to IB, and finding a solution for it was one of the key motivations for developing fsQCA (Ragin, 2000, 2008). The method can also be applied to large sample sizes, but there is no requirement for this (Greckhamer, Misangyi, & Fiss, 2013; Ragin, 2008). The absence of such requirement makes it possible, for example, to conduct studies that make comparisons between countries or sub-national units. A constraint in such studies is typically that the number of observations is limited: there are only a few dozen advanced industrialized countries. The total number of firms meeting certain criteria may also be small. For instance, Miska, Witt, and Stahl (2016) found that only 29 Chinese MNEs were industry leaders with a global footprint. They might have abandoned their study addressing the issue of global footprint if fsQCA had not been available.

Fifth, the ability of fsQCA to analyze set-theoretic relationships for small sample sizes may help enhance qualitative research. One practical challenge for qualitative researchers is convincing journal reviewers that the patterns they claim to have identified are truly present in the data. Assuming that authors have at least 12 cases, fsQCA may help in two ways: (1) identifying non-obvious, complex patterns in the data, thereby facilitating inductive analysis; and (2) showing that the solutions it generates are consistent with the patterns extracted from the data. While this approach does not amount to statistical hypothesis testing in the conventional sense (as discussed earlier), it can help build confidence in the validity of the findings.

Sixth, the capacity of fsQCA to accommodate causal asymmetry – the possibility that the conditions leading to the presence of an outcome may be different from those leading to its absence – can prove useful in questioning assumptions in current IB theory. For instance, a particular condition may facilitate early internationalization of a new venture, but the absence of this condition will not necessarily be associated with the absence of early internationalization. In addition, even though the presence of this condition in a configuration of complementary conditions may inhibit early internationalization, in other cases the same condition may be irrelevant or even helpful. These kinds of causal patterns are not likely to be identified by traditional analytical techniques.

As a final note, we express our hope that IB scholars will increasingly apply modern configurational thinking in their studies of complex IB phenomena, and that fsQCA will become a common instrument in the field’s empirical toolbox.

# NOTES

1 Note that this is distinct from causality as such. As with regression analysis, QCA alone cannot establish causality.

$^ 2 \mathrm { I n }$ practical terms, a calibration value of $^ { \prime } 0 . 5 ^ { \prime }$ is best avoided, because it establishes the ‘point of maximum ambiguity’, where it is not clear whether a condition is present or absent. Fuzzy-set QCA software applications may drop observations with this value, so the usual recommendation is to assign a value close to $^ { \prime } 0 . 5 ^ { \prime }$ , such as $^ { \prime } 0 . 4 9 9 ^ { \prime }$ .

# REFERENCES

Bell, R.G., Filatotchev, I., & Aguilera, R. V. 2014. Corporate governance and investors’ perceptions of foreign IPO value: An institutional perspective. Academy of Management Journal, 57(1): 301–320.   
Braumoeller, B. F. 2015. Guarding against false positives in qualitative comparative analysis. Political Analysis, 23(4): 471–487.   
Buckley, P. J., Doh, J. P., & Benischke, M. H. 2017. Towards a renaissance in international business research? Big questions, grand challenges, and the future of IB scholarship. Journal of International Business Studies, 48(9): 1045–1064.   
Chen, L., Li, Y., & Fan, D. 2018. How do emerging multinationals configure political connections across institutional contexts?. Global Strategy Journal, 8(3): 447–470.   
Ciravegna, L., Kuivalainen, O., Kundu, S. K., & Lopez, L. E. (2018). The antecedents of early internationalization: A configurational perspective. International Business Review, 27(6): 1200–1212.   
Clark, D. R., Li, D., & Shepherd, D. A. 2018. Country familiarity in the initial stage of foreign market selection. Journal of International Business Studies, 49(4): 442–472.   
Crilly, D. 2011. Predicting stakeholder orientation in the multinational enterprise: A mid-range theory. Journal of International Business Studies, 42(5): 694–717.   
Dul, J. 2016. Necessary condition analysis (NCA) logic and methodology of ‘‘necessary but not sufficient’’ causality. Organizational Research Methods, 19(1): 10–52.   
Dunning, J. H. 1988. The eclectic paradigm of international production: A restatement and some possible extensions. Journal of International Business Studies, 19(1): 1–31.   
Fainshmidt, S., Smith, A., & Judge, W. Q. 2016. National competitiveness and porter’s diamond model: The role of MNE penetration and governance quality. Global Strategy Journal, 6(2): 81–104.   
Fainshmidt, S., Wenger, L., Pezeshkan, A., & Mallon, M. R. 2019. When do dynamic capabilities lead to competitive advantage? The importance of strategic fit. Journal of Management Studies, 56(4), 758–787.   
Fiss, P. C. 2007. A set-theoretic approach to organizational configurations. Academy of Management Review, 32(4): 1180–1198.   
Fiss, P. C. 2011. Building better causal theories: A fuzzy set approach to typologies in organization research. Academy of Management Journal, 54(2): 393–420.   
Greckhamer, T. 2016. CEO compensation in relation to worker compensation across countries: The configurational impact of country-level institutions. Strategic Management Journal, 37(4): 793–815.   
Greckhamer, T., Furnari, S., Fiss, P. C., & Aguilera, R. V. 2018. Studying configurations with qualitative comparative analysis: Best practices in strategy and organization research. Strategic Organization, 16: 482–495.   
Greckhamer, T., Misangyi, V. F., & Fiss, P. C. 2013. The two QCAs: From a small-n to a large-n set theoretic approach. In P. C. Fiss, B. Cambre´, & A. Marx (Eds) Configurational theory and methods in organizational research: 49–75. Bingley: Emerald.   
Hall, P. A., & Soskice, D. 2001. An introduction to varieties of capitalism. In P.A. Hall & D. Soskice (Eds) Varieties of capitalism: The institutional foundations of comparative advantage: 1–68. Oxford: Oxford University Press.   
Judge, W. Q., Fainshmidt, S., & Brown III, J. L. 2014. Which model of capitalism best delivers both wealth and equality? Journal of International Business Studies, 45(4): 363–386.   
Kim, M. 2013. Many roads lead to Rome: Implications of geographic scope as a source of isolating mechanisms. Journal of International Business Studies, 44(9): 898–921.   
Marx, A. 2006. Towards a more robust model specification in QCA: Results from a methodological experiment, COMPASSS working papers: COMPASSS.   
Meyer, A. D., Tsui, A. S., & Hinings, C. R. 1993. Configurational approaches to organizational analysis. Academy of Management Journal, 36(6): 1175–1195.   
Miller, D. 1987. The genesis of configuration. Academy of Management Review, 12(4): 686–701.   
Misangyi, V. F., Greckhamer, T., Furnari, S., Fiss, P. C., Crilly, D., & Aguilera, R. 2017. Embracing causal complexity: The emergence of a neo-configurational perspective. Journal of Management, 43(1): 255–282.   
Miska, C., Witt, M. A., & Stahl, G. K. 2016. Drivers of global CSR integration and local CSR responsiveness: Evidence from Chinese MNEs. Business Ethics Quarterly, 26(3): 317–345.   
Nielsen, B., Eden L., & Verbeke, A, 2020. Research methods in international business: Challenges and advances. In L. Eden, B. Nielsen, & A. Verbeke (Eds) Research methods in international business: 3–41. Cham: Palgrave Mcmillan.   
Pajunen, K. 2008. Institutions and inflows of foreign direct investment: A fuzzy-set analysis. Journal of International Business Studies, 39(4): 652–669.   
Ragin, C. 1987. The comparative method: Moving beyond qualitative and quantitative methods. Berkeley: University of California.   
Ragin, C. C. 2000. Fuzzy-set social science. Chicago: University of Chicago Press.   
Ragin, C. C. 2008. Redesigning social inquiry: Fuzzy sets and beyond. New York: Wiley Online Library.   
Schneider, C. Q., & Wagemann, C. 2012. Set-theoretic methods for the social sciences: A guide to qualitative comparative analysis. Cambridge: Cambridge University Press.

Schneider, M. R., Schulze-Bentrop, C., & Paunescu, M. 2010. Mapping the institutional capital of high-tech firms: A fuzzyset analysis of capitalist variety and export performance. Journal of International Business Studies, 41(2): 246–266. Verbeke, A., Ciravegna, L., Lopez, L. E., & Kundu, S. K. 2018. Five configurations of opportunism in international market entry. Journal of Management Studies, 56 (7): 1287–1313. Whitley, R. 1999. Divergent capitalisms: The social structuring and change of business systems. Oxford: Oxford University Press. Witt, M. A., & Jackson, G. 2016. Varieties of capitalism and institutional comparative advantage: A test and reinterpretation. Journal of International Business Studies, 47(7): 778–806.

Publisher’s Note Springer Nature remains neutral with regard to jurisdictional claims in published maps and institutional affiliations.